﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Master/MasterPage.master" AutoEventWireup="true" CodeBehind="Sales.aspx.cs" Inherits="PirTickets.Sales" %>
<%@ Register Assembly="obout_Window_NET" Namespace="OboutInc.Window" TagPrefix="owd" %>
<%@ Register Assembly="obout_Grid_NET" Namespace="Obout.Grid" TagPrefix="cc1" %>
<asp:Content ID="Content1" ContentPlaceHolderID="Head" runat="server">
    </asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentSide" runat="server">
    <asp:Label ID="lblSalesTaxes" runat="server" Text=""></asp:Label>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">
    <h1>Item Sales</h1>
    <br />
    <asp:Button ID="btNew" runat="server" Text="New Sale" OnClick="btNew_Click" Font-Size="Larger" Height="39px" Width="253px" />
    <table>
        <tr><td style="vertical-align:Top">
            <asp:UpdatePanel ID="UpdatePanel1" runat="server">
                <ContentTemplate>
                    
                    <asp:Label ID="lblCustSearch" runat="server" Text="<h3>Customer</h3>" AssociatedControlID="plCustSearch"></asp:Label>
                    <asp:Panel ID="plCustSearch" runat="server" BorderStyle="Inset">
                        <asp:DropDownList ID="DDCustomerID" runat="server" ClientIDMode="Static" OnDataBound="DDCustomerID_DataBound" AutoPostBack="True" OnSelectedIndexChanged="DDCustomerID_SelectedIndexChanged">
                        </asp:DropDownList><br />
                        <input id="btnFind" runat="server" type="button" value="Find" onclick="wdSearch.Open(); wdSearch.bringToFront(); wdSearch.screenCenter();" />

                        <input id="btnNew" runat="server" type="button" value="New" onclick="wdNewCust.Open(); wdNewCust.bringToFront(); wdNewCust.screenCenter();" />
                        <br />
                        <asp:Label ID="lblCustomer" runat="server" Text=""></asp:Label>
                        <br />
                    </asp:Panel>
                </ContentTemplate>
            </asp:UpdatePanel>

            
            <asp:Label ID="lbltemSearch" runat="server" Text="<h3>Item Search</h3>" AssociatedControlID="plItemSearch"></asp:Label>
            <asp:Panel ID="plItemSearch" runat="server" BorderStyle="Inset">
                Item Code:<asp:TextBox ID="tbItemCode" runat="server" AutoPostBack="True" OnTextChanged="tbItemCode_TextChanged"></asp:TextBox>
                    <br />
                <asp:Label ID="lblDescription" runat="server" Text=""></asp:Label>
                <br />
                <asp:Label ID="lblPrice" runat="server" Text="£00.00"></asp:Label>
                <br />
                <asp:Button ID="btAdd" runat="server" Text="Add" OnClick="btAdd_Click" Visible="False" />    
                <asp:Button ID="btSearch" runat="server" Text="Find" OnClick="btSearch_Click" />
                <asp:Button ID="btClear" runat="server" OnClick="btClear_Click" Text="Clear" />
                <br />
                            
            </asp:Panel>

            <asp:Label ID="lblSalesItems" runat="server" Text="<h3>Sale Items</h3>" AssociatedControlID="plSalesItems"></asp:Label>
                    <asp:Panel ID="plSalesItems" runat="server" BorderStyle="Inset">
                        
                        <asp:GridView ID="gvSalesItems" runat="server" AutoGenerateColumns="False" DataKeyNames="salesId,ItemSeq" DataSourceID="sqlItemSales" CellPadding="3" ForeColor="Black" GridLines="Vertical" 
                            OnRowDataBound="gvSalesItems_RowDataBound" OnRowCommand="gvSalesItems_RowCommand" OnRowCreated="gvSalesItems_RowCreated" ShowFooter="True" SkinID="gridviewSkin" BackColor="White" BorderColor="#999999" BorderStyle="Solid" BorderWidth="1px">
                            <AlternatingRowStyle BackColor="#CCCCCC" />
                            <Columns>
                                <asp:BoundField DataField="salesId" HeaderText="salesId" ReadOnly="True" Visible="False" />
                                <asp:BoundField DataField="ItemSeq" HeaderText="ItemSeq" ReadOnly="True" Visible="False" />
                                <asp:BoundField DataField="partId" HeaderText="partId"  Visible="False" />
                                <asp:BoundField DataField="partCode" HeaderText="Part"  />
                                <asp:BoundField DataField="partname" HeaderText="Name" HeaderStyle-HorizontalAlign="Left" ItemStyle-HorizontalAlign="Left">
                                <HeaderStyle HorizontalAlign="Left" />
                                <ItemStyle HorizontalAlign="Left" />
                                </asp:BoundField>
                                <asp:BoundField DataField="cost" HeaderText="Cost" DataFormatString="{0:c}" ReadOnly="True" />
                
                                <asp:TemplateField HeaderText="Quant.">
                                    <ItemTemplate>
                                        <asp:Label ID="lblUnitsInStock" runat="server" Text='<%# Eval("quant") %>' />
                                    </ItemTemplate>
                                    <FooterTemplate>
                                        <asp:Label ID="lblTotalUnit" runat="server" />
                                    </FooterTemplate>
                                </asp:TemplateField>

                                <asp:TemplateField HeaderText="Total">
                                    <ItemTemplate>
                                        <asp:Label ID="lblPrice" runat="server" Text='<%# Eval("total")%>'  />
                                    </ItemTemplate>
                                    <FooterTemplate>
                                        <asp:Label ID="lblTotalPrice" runat="server" />
                                    </FooterTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField >
                                    <ItemTemplate>
                                        <asp:ImageButton ID="imgPlus" runat="server" ImageUrl="~/images/plus.png" Width="20px" CommandName="add" CommandArgument='<%# Eval("partId") %>' />
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField>
                                    <ItemTemplate>
                                        <asp:ImageButton ID="imgMinus" runat="server" ImageUrl="~/images/minus.png" Width="20px" CommandName="remove" CommandArgument='<%# Eval("partId") %>' />
                                    </ItemTemplate>
                                </asp:TemplateField>
                            </Columns>
                            <FooterStyle BackColor="#CCCCCC" />
                            <HeaderStyle BackColor="Black" Font-Bold="True" ForeColor="White" />
                            <PagerStyle BackColor="#999999" ForeColor="Black" HorizontalAlign="Center" />
                            <SelectedRowStyle BackColor="#000099" Font-Bold="True" ForeColor="White" />
                            <SortedAscendingCellStyle BackColor="#F1F1F1" />
                            <SortedAscendingHeaderStyle BackColor="#808080" />
                            <SortedDescendingCellStyle BackColor="#CAC9C9" />
                            <SortedDescendingHeaderStyle BackColor="#383838" />
                        </asp:GridView>
                        
                    </asp:Panel>

            <br />
            
            <asp:Button ID="btCancel" runat="server" Text="Cancel" OnClick="btCancel_Click" OnClientClick="return confirm('Cancel Sale?');" Visible="False" Height="36px" Width="123px" />
            &nbsp;
            <asp:Button ID="btComplete" runat="server" Text="Complete Sale" OnClick="btComplete_Click" OnClientClick="return confirm('Complete this Sale?');" Visible="False" Height="36px" Width="134px" />
            </td>
           
            <td style="column-width: 360px; vertical-align: top" rowspan="2">
                <asp:ListView runat="server" ID="CategoryListView" ItemPlaceholderID="itemPlaceHolder"
                    GroupPlaceholderID="groupPlaceHolder" GroupItemCount="5" OnItemCommand="CategoryListView_ItemCommand" DataKeyNames="id" DataSourceID="sqlCategories">
                    <ItemTemplate>
                        <td id="Td1" runat="server" style="background-color: #DCDCDC; color: #000000;">
                            &nbsp;<asp:LinkButton ID="lbCategory" runat="server" Text='<%# Eval("categoryname") %>' CommandArgument='<%# Eval("id") %>'></asp:LinkButton>
                            &nbsp;
                        </td>
                    </ItemTemplate>
                    <AlternatingItemTemplate>
                        <td id="Td2" runat="server" style="background-color: #FFF8DC;">
                            &nbsp;<asp:LinkButton ID="lbCategory" runat="server" Text='<%# Eval("categoryname") %>' CommandArgument='<%# Eval("id") %>'></asp:LinkButton>
                            &nbsp;
                        </td>
                    </AlternatingItemTemplate>
                    <EmptyDataTemplate>
                        <table id="Table1" runat="server" style="background-color: #FFFFFF; border-collapse: collapse; border-color: #999999; border-style: none; border-width: 1px;">
                            <tr>
                                <td>No Parts Categories Available</td>
                            </tr>
                        </table>
                    </EmptyDataTemplate>
                    <EmptyItemTemplate>
                        <td id="Td3" runat="server" />
                    </EmptyItemTemplate>
                    <GroupTemplate>
                        <tr id="itemPlaceholderContainer" runat="server">
                            <td id="itemPlaceHolder" runat="server"></td>
                        </tr>
                    </GroupTemplate>
                    <LayoutTemplate>
                        <table id="Table2" runat="server">
                            <tr id="Tr1" runat="server">
                                <td id="Td4" runat="server">
                                    <table id="groupPlaceholderContainer" runat="server" border="1" style="background-color: #FFFFFF; border-collapse: collapse; border-color: #999999; border-style: none; border-width: 1px; font-family: Verdana, Arial, Helvetica, sans-serif;">
                                        <tr id="groupPlaceHolder" runat="server">
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                            <tr id="Tr2" runat="server">
                                <td id="Td5" runat="server" style="text-align: center; background-color: #CCCCCC; font-family: Verdana, Arial, Helvetica, sans-serif; color: #000000;"></td>
                            </tr>
                        </table>
                    </LayoutTemplate>
                 </asp:ListView>
                <asp:HiddenField ID="hdnCategory" runat="server" />
                <asp:ListView runat="server" ID="ImageItemsListView" Visible="true" ItemPlaceholderID="itemPlaceHolder"
                    GroupPlaceholderID="groupPlaceHolder" GroupItemCount="3" OnItemCommand="ImageItemsListView_ItemCommand" DataSourceID="sqlParts" OnSelectedIndexChanged="ImageItemsListView_SelectedIndexChanged">
                    <LayoutTemplate>
                        <table id="Table3" runat="server" width="450px">
                            <tr id="Tr3" runat="server">
                                <td id="Td6" runat="server">
                                    <table id="groupPlaceholderContainer" runat="server" border="1" style="background-color: #FFFFFF; border-collapse: collapse; border-color: #999999; border-style: none; border-width: 1px; font-family: Verdana, Arial, Helvetica, sans-serif;">
                                        <tr id="groupPlaceHolder" runat="server">
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                            <tr id="Tr4" runat="server">
                                <td id="Td7" runat="server" style="text-align: center; background-color: #5D7B9D; font-family: Verdana, Arial, Helvetica, sans-serif; color: #FFFFFF"></td>
                            </tr>
                        </table>
                    </LayoutTemplate>
                    <GroupTemplate>
                        <tr id="itemPlaceholderContainer" runat="server">
                            <td id="itemPlaceHolder" runat="server"></td>
                        </tr>
                    </GroupTemplate>

                    <ItemTemplate>
                        <td id="Td8" runat="server" style="background-color: #FFFFFF; color: #333333; vertical-align: top">
                            <asp:Label ID="lblPartName" runat="server" Text='<%# Eval("partname") %>'></asp:Label>
                            <asp:ImageButton ID="itemImageButton" runat="server"
                                CommandArgument='<%# Eval("PartId") %>'
                                ImageUrl='<%# Eval("filepath") %>' Width="120" />
                            £<asp:Label ID="lblCost" runat="server" Text='<%# Eval("cost") %>'></asp:Label><br />
                            Stock:<asp:Label ID="Label1" runat="server" Text='<%# Eval("quant") %>'></asp:Label>
                        </td>

                    </ItemTemplate>
                    <EmptyItemTemplate>
                        <td id="Td9" runat="server" />
                    </EmptyItemTemplate>
                    <AlternatingItemTemplate>
                                    
                        <td id="Td10" runat="server" style="background-color: #FFFFFF; color: #284775; vertical-align:top">
                            <asp:Label ID="lblPartName" runat="server" Text='<%# Eval("partname") %>'></asp:Label>
                            <asp:ImageButton ID="itemImageButton" runat="server"
                                CommandArgument='<%# Eval("PartId") %>'
                                ImageUrl='<%# Eval("filepath") %>' Width="120" />
                            £<asp:Label ID="lblCost" runat="server" Text='<%# Eval("cost") %>'></asp:Label><br />
                            Stock:<asp:Label ID="Label1" runat="server" Text='<%# Eval("quant") %>'></asp:Label>


                        </td>
                    </AlternatingItemTemplate>

                    <EmptyDataTemplate>
                        <table id="Table4" runat="server" style="background-color: #FFFFFF; border-collapse: collapse; border-color: #999999; border-style: none; border-width: 1px;">
                            <tr>
                                <td>
                                    <h1>No Parts in this category</h1>
                                </td>
                            </tr>
                        </table>
                    </EmptyDataTemplate>

                </asp:ListView>
                <%--            <asp:DataPager ID="PgrItemsListView" runat="server"
        PagedControlID="ImageItemsListView" PageSize="12"
        OnPreRender="PgrItemsListView_PreRender">
        <Fields>
            <asp:NextPreviousPagerField ButtonType="Link"
                PreviousPageText="<< " NextPageText=" >>" />
        </Fields>
    </asp:DataPager>--%>


                <asp:SqlDataSource ID="sqlParts" runat="server" ConnectionString="<%$ ConnectionStrings:PirTickets %>" SelectCommand="tr_getPartsByCategory" SelectCommandType="StoredProcedure">
                    <SelectParameters>
                        <asp:ControlParameter ControlID="hdnCategory" DefaultValue="1" Name="category" PropertyName="Value" Type="Int32" />
                    </SelectParameters>
                </asp:SqlDataSource>
                <asp:SqlDataSource ID="sqlCategories" runat="server" ConnectionString="<%$ ConnectionStrings:PirTickets %>" SelectCommand="SELECT [id], [categoryname], [description] FROM [partscategory]"></asp:SqlDataSource>
                </td>
        </tr>
        <tr>
            <td style="vertical-align: top">
                

                
             </td>
        </tr>      
    </table>
    <asp:SqlDataSource ID="sqlItemSales" runat="server" ConnectionString="<%$ ConnectionStrings:PirTickets %>"
        SelectCommand="tr_salesItems" SelectCommandType="StoredProcedure">
        <SelectParameters>
            <asp:Parameter DefaultValue="0" Name="salesId" Type="Int32" />
        </SelectParameters>
    </asp:SqlDataSource>

    <owd:window id="wdSearch" runat="server" title="Find Customer" ismodal="true" isresizable="True" isdraggable="True" height="800" width="750" visibleonload="false" opacity="100" stylefolder="Styles/wdstyles/blue">
        <asp:GridView ID="gvCustomers" runat="server" Width="720px"
            AutoGenerateSelectButton="True" DataKeyNames="CustomerID"
            OnSelectedIndexChanged="gvCustomers_SelectedIndexChanged"
            AllowPaging="True" AllowSorting="True" AutoGenerateColumns="False"
            DataSourceID="SqlDataCustomers"
            OnPageIndexChanged="gvCustomers_onPaging"
            OnRowDataBound="gvCustomers_RowDataBound" SkinID="gridviewSkin" PageSize="20" EmptyDataText="No Customers to View" EnableSortingAndPagingCallbacks="False" PagerSettings-Mode="NextPreviousFirstLast">
            <Columns>
                <asp:BoundField DataField="CustomerID" HeaderText="ID"
                    SortExpression="CustomerID" />
                <asp:BoundField DataField="OrganizationName" HeaderText="Organization"
                    SortExpression="OrganizationName" />
                <asp:BoundField DataField="Username" HeaderText="Username"
                    SortExpression="Username" />
                <asp:BoundField DataField="FirstName" HeaderText="FirstName"
                    SortExpression="FirstName" />
                <asp:BoundField DataField="LastName" HeaderText="LastName"
                    SortExpression="LastName" />
                <asp:BoundField DataField="City" HeaderText="City" SortExpression="City" />
                <asp:CheckBoxField DataField="Trader" HeaderText="Trader"
                    SortExpression="Trader" />
            </Columns>
        </asp:GridView>
        <b>Search:</b>
        <table>
            <tr>
                <td>Organization:</td>
                <td>
                    <asp:TextBox ID="txtOrg" runat="server" AutoPostBack="True" OnTextChanged="txtOrg_TextChanged" Width="174px"></asp:TextBox></td>
                <td>Name:</td>
                <td>
                    <asp:TextBox ID="txtName" runat="server" AutoPostBack="True" OnTextChanged="txtName_TextChanged" Width="158px"></asp:TextBox></td>
                <td>City:</td>
                <td>
                    <asp:TextBox ID="txtCitySearch" runat="server" AutoPostBack="True" OnTextChanged="txtCity_TextChanged" Width="115px" /></td>
                <td>
                    <asp:Button ID="Button1" runat="server" Text="Clear" Width="54px" OnClick="btClear_Click" />
                </td>
            </tr>
            <tr>
                <td>
                    <asp:HiddenField ID="Hidden1" runat="server" />
                </td>
                <td>&nbsp;</td>
                <td>&nbsp;</td>
                <td></td>
                <td align="right"></td>
                <td align="right">
                    <input id="Button2" type="button" value="Cancel" onclick="wdSearch.Close();" /></td>
                <td></td>
            </tr>
        </table>
        <asp:SqlDataSource ID="SqlDataCustomers" runat="server" ConnectionString="<%$ ConnectionStrings:PirTickets %>"
            SelectCommand="SELECT [CustomerID], [OrganizationName], [Username], [FirstName], [LastName], [City], [Trader] FROM [Customers]"></asp:SqlDataSource>
    </owd:window>

    <owd:window id="wdNewCust" runat="server" title="Add New Service Item" ismodal="true" isresizable="True" isdraggable="True" height="800" width="750" visibleonload="false" opacity="100" stylefolder="Styles/wdstyles/blue">
        <table cellpadding="2" border="0">
            <tr>
                <td colspan="4">
                    <h3>Enter New Customer Details</h3>
                </td>
            </tr>
            <tr>
                <td class="style3">ID</td>
                <td>&nbsp;</td>
                <td>
                    <asp:TextBox ID="TxtCustomerID" MaxLength="10" runat="server" ReadOnly="True">New</asp:TextBox>
                </td>
                <td class="style4">&nbsp;</td>
            </tr>
            <tr>
                <td class="style3">Organization Name:</td>
                <td></td>
                <td>
                    <asp:TextBox ID="TxtOrganizationName" MaxLength="50" runat="server" Width="282px" /></td>
                <td class="style4">Trade? :<asp:CheckBox ID="cbTrade" runat="server" />
                </td>
            </tr>
            <tr>
                <td class="style3">Contact Title:</td>
                <td>&nbsp;</td>
                <td>
                    <asp:TextBox ID="TxtContactTitle" MaxLength="50" runat="server"
                        Width="74px" /></td>
                <td class="style4">&nbsp;</td>
            </tr>
            <tr>
                <td class="style3">First Name:</td>
                <td></td>
                <td>
                    <asp:TextBox ID="TxtFirstName" MaxLength="50" runat="server" /></td>
                <td class="style4">
                    <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ControlToValidate="TxtFirstName" ErrorMessage="First Name Required" ValidationGroup="vgNew"></asp:RequiredFieldValidator>
                </td>
            </tr>
            <tr>
                <td class="style3">Last Name:</td>
                <td></td>
                <td>
                    <asp:TextBox ID="TxtLastName" MaxLength="50" runat="server"
                        Width="171px" /></td>
                <td class="style4">
                    <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" ControlToValidate="TxtLastName" ErrorMessage="Surname Required" ValidationGroup="vgNew"></asp:RequiredFieldValidator>
                </td>
            </tr>
            <tr>
                <td class="style3">Address:</td>
                <td></td>
                <td>
                    <asp:TextBox ID="TxtAddress" MaxLength="255" runat="server" Width="239px" /></td>
                <td class="style4"></td>
            </tr>
            <tr>
                <td class="style3">Region:</td>
                <td></td>
                <td>
                    <asp:TextBox ID="TxtRegion" MaxLength="50" runat="server" Width="165px" /></td>
                <td class="style4"></td>
            </tr>
            <tr>
                <td class="style3">City:</td>
                <td></td>
                <td>
                    <asp:TextBox ID="TxtCity" MaxLength="50" runat="server" Width="155px" /></td>
                <td class="style4"></td>
            </tr>
            <tr>
                <td class="style3">State:</td>
                <td></td>
                <td>
                    <asp:TextBox ID="TxtState" MaxLength="50" runat="server" /></td>
                <td class="style4"></td>
            </tr>
            <tr>
                <td class="style3">Postal Code:</td>
                <td></td>
                <td>
                    <asp:TextBox ID="TxtPostalCode" MaxLength="20" runat="server" /></td>
                <td class="style4"></td>
            </tr>
            <tr>
                <td class="style3">Country:</td>
                <td></td>
                <td>
                    <asp:TextBox ID="TxtCountry" MaxLength="50" runat="server">USA</asp:TextBox>
                </td>
                <td class="style4"></td>
            </tr>
            <tr>
                <td class="style3">Email:</td>
                <td></td>
                <td>
                    <asp:TextBox ID="TxtEmailName" MaxLength="50" runat="server" Width="307px" /></td>
                <td class="style4"></td>
            </tr>
            <tr>
                <td class="style3">Phone Number:</td>
                <td></td>
                <td>
                    <asp:TextBox ID="TxtPhoneNumber" ClientIDMode="Static" MaxLength="30" runat="server"
                        Width="171px" /></td>
                <td class="style4">
                    <asp:RequiredFieldValidator ID="RequiredFieldValidator3" runat="server" ErrorMessage="Phone Number Required" ControlToValidate="TxtPhoneNumber" ValidationGroup="vgNew"></asp:RequiredFieldValidator>
                </td>
            </tr>
            <tr>
                <td class="style3">Mobile Phone:</td>
                <td>&nbsp;</td>
                <td>
                    <asp:TextBox ID="TxtMobilePhone" MaxLength="30" runat="server"
                        Width="171px" /></td>
                <td class="style4"></td>
            </tr>
            <tr>
                <td class="style3">Fax Number:</td>
                <td></td>
                <td>
                    <asp:TextBox ID="TxtFaxNumber" MaxLength="30" runat="server"
                        Width="168px" /></td>
                <td class="style4"></td>
            </tr>
            <tr>
                <td valign="top" class="style3">Note:</td>
                <td></td>
                <td>
                    <asp:TextBox ID="TxtNote" MaxLength="1073741823"
                        TextMode="MultiLine" Rows="5" runat="server" Width="293px" /></td>
                <td class="style4"></td>
            </tr>
            <tr>
                <td class="style3">Payment Terms:</td>
                <td></td>
                <td>
                    <asp:DropDownList ID="DDPayment" runat="server" DataSourceID="SqlDataPayments" DataTextField="PaymentTerms" DataValueField="ID">
                    </asp:DropDownList>
                    <asp:SqlDataSource ID="SqlDataPayments" runat="server" ConnectionString="<%$ ConnectionStrings:PirTickets %>"
                        SelectCommand="SELECT [ID], [PaymentTerms], [NumberOfDays] FROM [PaymentTerms]"></asp:SqlDataSource>
                </td>
                <td class="style4"></td>
            </tr>
            <tr>
                <td class="style3">Preferred<br />
                    Delivery Route:</td>
                <td></td>
                <td>
                    <asp:DropDownList ID="ddShipping" runat="server" DataSourceID="SqlDataShipping" DataTextField="ShipMethod" DataValueField="ID">
                    </asp:DropDownList>
                    <asp:SqlDataSource ID="SqlDataShipping" runat="server" ConnectionString="<%$ ConnectionStrings:PirTickets %>"
                        SelectCommand="SELECT [ID], [ShipMethod] FROM [shipvia]"></asp:SqlDataSource>
                </td>
                <td class="style4"></td>
            </tr>
            <tr>
                <td class="style3">&nbsp;</td>
                <td></td>
                <td>&nbsp;</td>
                <td class="style4"></td>
            </tr>
            <tr>
                <td colspan="2"></td>
                <td colspan="2">
                        <asp:Button ID="BtnUpdateView" runat="server" Text="Save" OnClick="BtnUpdateView_Click" Width="136px" ValidationGroup="vgNew" />&nbsp;
                        <asp:Button ID="Button3" CausesValidation="false" runat="server" Text="Cancel" OnClientClick="wdNewCust.Close();" Width="127px" />
                </td>
            </tr>
        </table>

    </owd:window>
</asp:Content>
